/*:
 * @target MZ
 * @plugindesc Save fix for NRP_ParallaxesPlus: keep current opacity on save/load.
 * @author HS
 * @help Place below NRP_ParallaxesPlus. No parameters.
 */
(() => {
  // 既存の保存処理を丸ごと差し替え：シーン上の見た目をそのまま $gameMap に退避
  Game_Map.prototype.setParallaxPlus = function() {
    const spriteset = SceneManager._scene?._spriteset;
    const list = spriteset?._parallaxPlus || [];
    this._parallaxPlus = [];
    for (const p of list) {
      // 現在表示中の値をそのまま保存。ロード後に再フェードさせないため duration を0に固定
      const save = {
        id: p.id,
        name: p.name,
        scrollX: p.scrollX,
        scrollY: p.scrollY,
        z: p.z,
        paramOpacity: (p.paramOpacity ?? p.opacity),
        opacity: p.opacity,
        startOpacity: p.startOpacity,
        duration: 0,
        durationCount: 0,
        blendMode: p.blendMode,
        parallaxX: p.parallaxX,
        parallaxY: p.parallaxY,
        shiftX: p.shiftX,
        shiftY: p.shiftY,
        noLoopX: p.noLoopX,
        noLoopY: p.noLoopY,
        originalWidth: p.originalWidth,
        originalHeight: p.originalHeight,
        origin: { x: p.origin.x, y: p.origin.y },
        mapX: p.mapX, mapY: p.mapY,
        x: p.x, y: p.y,
        isLimitX: p.isLimitX, isLimitY: p.isLimitY,
      };
      this._parallaxPlus.push(save);
    }
  };
})();
